/*
 * NetworkStructure.cpp
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */


#include <NetworkStructure.h>


void init_infected_structure(const char *input_file_name, const char *file_type, infected_structure * p_infected_parameters) {

    igraph_t input_graph;

    // checking file type and loading graph
    if (!strcmp(file_type, "gml")) {
    	FILE * p_file;
		p_file = fopen(input_file_name, "r");
		if (p_file == NULL) {
			printf("Wrong input file name!\n");
			exit(1);
		}
        igraph_read_graph_gml(&input_graph, p_file);
        p_infected_parameters->use_temporal_network_structure = 0;
        p_infected_parameters->use_weighted_static_network = 0;
        fclose(p_file);
    } else if (!strcmp(file_type, "edgelist")) {
		FILE * p_file;
		p_file = fopen(input_file_name, "r");
		if (p_file == NULL) {
			printf("Wrong input file name!\n");
			exit(1);
		}
        igraph_read_graph_edgelist(&input_graph, p_file, 0, false);
        p_infected_parameters->use_temporal_network_structure = 0;
        p_infected_parameters->use_weighted_static_network = 0;
        fclose(p_file);
    } else if (!strcmp(file_type, "temporal")){
    	FILE * p_file;
		p_file = fopen(input_file_name, "r");
		if (p_file == NULL) {
			printf("Wrong input file name!\n");
			exit(1);
		}
		p_infected_parameters->use_weighted_static_network = 0;
    	p_infected_parameters->use_temporal_network_structure = 1;
    	p_infected_parameters->contact_array_1 = new vector<int>();
    	p_infected_parameters->contact_array_2 = new vector<int>();
    	p_infected_parameters->time_contact_array = new vector<int>();
    	read_temporal_contacts(p_file, p_infected_parameters);
    	p_infected_parameters->zero_time = p_infected_parameters->time_contact_array->at(0);
    	//agregate network for other statistics
    	igraph_empty(&input_graph, (igraph_integer_t) p_infected_parameters->no_of_nodes, IGRAPH_UNDIRECTED);
    	aggregate_temporal_network(p_infected_parameters, &input_graph);
    	fclose(p_file);
    }else if ( !strcmp(file_type, "weighted") ){
    	FILE * p_file;
		p_file = fopen(input_file_name, "r");
		if (p_file == NULL) {
			printf("Wrong input file name!\n");
			exit(1);
		}
    	p_infected_parameters->use_temporal_network_structure = 0;
    	p_infected_parameters->use_weighted_static_network = 1;

    	igraph_spmatrix_t  * mat = (igraph_spmatrix_t *) malloc(sizeof (igraph_spmatrix_t));
    	p_infected_parameters->no_of_nodes = read_max_node_id_from_weighted_file(p_file) + 1;

    	//printf("Num of nodes %d from edgelist extracted ! \n", (int) p_infected_parameters->no_of_nodes);
    	// weighted ids come from 1-n , so we want to leave corespondence and we add dummy zero node
    	fclose(p_file);
    	igraph_spmatrix_init( mat, p_infected_parameters->no_of_nodes, p_infected_parameters->no_of_nodes);
    	p_infected_parameters->weight_mat = mat;

    	igraph_empty(&input_graph, (igraph_integer_t) p_infected_parameters->no_of_nodes, IGRAPH_UNDIRECTED);
    	p_file = fopen(input_file_name, "r");
    	read_weighted_network(p_file, mat, &input_graph);
    	fclose(p_file);
    	//printf("Weighted network imported ! \n");

    }else{
        printf("wrong input file type!\n");
        //display_usage();
    }


    //if (p_infected_parameters->use_temporal_network_structure == 0){ //we use static network

	//  looking and saving as a graph the largest connected community (giant component)
	//    igraph_t * p_graph = (igraph_t *) malloc(sizeof (igraph_t));
	//    get_giant_component(&(input_graph), p_graph);
	//    p_infected_parameters->p_graph = p_graph;

	p_infected_parameters->p_graph = (igraph_t *) malloc(sizeof (igraph_t));
	//if (input_args->using_giant == TRUE) {
	//	get_giant_component(&(input_graph), p_infected_parameters->p_graph);
	//} else {
		igraph_copy(p_infected_parameters->p_graph, &input_graph);
	//}

	igraph_destroy(&input_graph);

	long int no_of_nodes = (long int) igraph_vcount(p_infected_parameters->p_graph);
	//if (input_args->using_giant == TRUE){
		//printf("number of nodes in giant component: %li\n", no_of_nodes);
	//} else {
		//printf("number of nodes in graph: %li\n", no_of_nodes);
	//}

	p_infected_parameters->no_of_nodes = no_of_nodes;

   // }

    /*
	//if input nodes don't exist, use all of them
	int i;
	if (igraph_vector_size(&(input_args->nodes)) == 0) {
		for (i = 0; i < no_of_nodes; ++i) {
			igraph_vector_push_back(&(input_args->nodes), i);
		}
	} else { //checking ids of nodes
		if (igraph_vector_max(&(input_args->nodes)) > no_of_nodes || igraph_vector_min(&(input_args->nodes)) < 0) {
			printf("Node id range should be 0..%li!\n", no_of_nodes);
			display_usage();
		}
	}
	*/



	// initialization of infected dqueue
	igraph_dqueue_t * dq_infected_nodes = (igraph_dqueue_t *) malloc(sizeof (igraph_dqueue_t));
	igraph_dqueue_init(dq_infected_nodes, p_infected_parameters->no_of_nodes);
	p_infected_parameters->dq_infected_nodes = dq_infected_nodes;

	igraph_dqueue_t * q_infected_nodes_all = (igraph_dqueue_t *) malloc(sizeof (igraph_dqueue_t));
	igraph_dqueue_init(q_infected_nodes_all, p_infected_parameters->no_of_nodes);
	p_infected_parameters->q_infected_nodes_all = q_infected_nodes_all;

	if (p_infected_parameters->use_temporal_network_structure == 0){ //we use static network
		// saving graph to an adjacency list
		igraph_adjlist_t * p_al = (igraph_adjlist_t *) malloc(sizeof (igraph_adjlist_t));
		igraph_adjlist_init(p_infected_parameters->p_graph, p_al, IGRAPH_ALL);
		p_infected_parameters->al = p_al;
    }

}

void aggregate_temporal_network(infected_structure * p_infected_parameters, igraph_t * graph_G){

	igraph_vector_t edges_set;
	igraph_vector_init ( &edges_set, 0 );

	int x,y;
	for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i ){
		x = p_infected_parameters->contact_array_1->at(i);
		y = p_infected_parameters->contact_array_2->at(i);
		igraph_vector_push_back (&edges_set, (igraph_integer_t) x);
		igraph_vector_push_back (&edges_set, (igraph_integer_t) y);

		igraph_vector_push_back (&edges_set, (igraph_integer_t) y);
		igraph_vector_push_back (&edges_set, (igraph_integer_t) x);
	}

	igraph_add_edges(graph_G, &edges_set, 0);
	igraph_vector_destroy( &edges_set );

	#ifdef IGRAPH_VERSION_0_6_5
	igraph_simplify(graph_G, (igraph_bool_t) 1, (igraph_bool_t) 1,0);
	#else
	igraph_simplify(graph_G, (igraph_bool_t) 1, (igraph_bool_t) 1);
	#endif
}

/*
 * Initilization of p_infected_structure from igraph_t * graph
 */
void init_infected_structure_from_graph(infected_structure * p_infected_parameters, igraph_t * graph ){

	p_infected_parameters->p_graph = (igraph_t *) malloc(sizeof (igraph_t));
	igraph_copy(p_infected_parameters->p_graph, graph);


	p_infected_parameters->no_of_nodes  = igraph_vcount(p_infected_parameters->p_graph);
	p_infected_parameters->use_dqueue_initial_cond = 1;
	p_infected_parameters->start_node = -1;
	p_infected_parameters->start_node2 = -1;


	igraph_dqueue_t * dq_infected_nodes = (igraph_dqueue_t *) malloc(sizeof (igraph_dqueue_t));
	igraph_dqueue_init(dq_infected_nodes, (long int) p_infected_parameters->no_of_nodes);
	p_infected_parameters->dq_infected_nodes = dq_infected_nodes;

	igraph_dqueue_t * q_infected_nodes_all = (igraph_dqueue_t *) malloc(sizeof (igraph_dqueue_t));
	igraph_dqueue_init(q_infected_nodes_all, p_infected_parameters->no_of_nodes);
	p_infected_parameters->q_infected_nodes_all = q_infected_nodes_all;

	igraph_adjlist_t * p_al = (igraph_adjlist_t *) malloc(sizeof (igraph_adjlist_t));
	igraph_adjlist_init(p_infected_parameters->p_graph, p_al, IGRAPH_ALL);
	p_infected_parameters->al = p_al;

}

void read_temporal_contacts(FILE *fp, infected_structure * p_infected_parameters){

	int con1, con2, time;

	int num_nodes;
	fscanf(fp, "%d \n", &num_nodes);
	p_infected_parameters->no_of_nodes = num_nodes + 1;
	int num_items = 0;
	while (fscanf(fp,"%d %d %d \n",&con1, &con2, &time) == 3){
		p_infected_parameters->contact_array_1->push_back(con1);
		p_infected_parameters->contact_array_2->push_back(con2);
		p_infected_parameters->time_contact_array->push_back(time);
		num_items++;
	}

}

void read_weighted_network(FILE *fp, igraph_spmatrix_t * mat_weight, igraph_t * graph_G){

	igraph_vector_t edges_set;
	igraph_vector_init ( &edges_set, 0 );
	//igraph_vector_reserve(&edges_infected, 2*init_size);

	int x,y;
	double w;
	while ( fscanf(fp,"%d %d %lf", &x, &y, &w) == 3){
		igraph_spmatrix_add_e( mat_weight, x, y, w);

		igraph_vector_push_back (&edges_set, (igraph_integer_t) x);
		igraph_vector_push_back (&edges_set, (igraph_integer_t) y);
	}

	igraph_add_edges(graph_G, &edges_set, 0);
	igraph_vector_destroy( &edges_set );
	#ifdef IGRAPH_VERSION_0_6_5
	igraph_simplify(graph_G, (igraph_bool_t) 1, (igraph_bool_t) 1,0);
	#else
	igraph_simplify(graph_G, (igraph_bool_t) 1, (igraph_bool_t) 1);
	#endif
}

long int read_max_node_id_from_weighted_file(FILE *fp){
	int max_node_id = 0;
	int x,y;
	double w;
	while ( fscanf(fp,"%d %d %lf", &x, &y, &w) == 3){
		if ( x > max_node_id ){
			max_node_id = x;
		}
		if ( y > max_node_id ){
			max_node_id = y;
		}
	}
	return max_node_id;
}

void destroy_infected_structure(infected_structure * p_infected_parameters) {

	if (p_infected_parameters->use_temporal_network_structure == 1){
		p_infected_parameters->contact_array_1->clear();
		free(p_infected_parameters->contact_array_1);
		p_infected_parameters->contact_array_2->clear();
		free(p_infected_parameters->contact_array_2);
		p_infected_parameters->time_contact_array->clear();
		free(p_infected_parameters->time_contact_array);
		igraph_dqueue_destroy(p_infected_parameters->dq_infected_nodes);
		free(p_infected_parameters->dq_infected_nodes);
	}else if(p_infected_parameters->use_weighted_static_network == 1){
		igraph_destroy(p_infected_parameters->p_graph);
		free(p_infected_parameters->p_graph);
		igraph_adjlist_destroy(p_infected_parameters->al);
		free(p_infected_parameters->al);
		igraph_dqueue_destroy(p_infected_parameters->dq_infected_nodes);
		free(p_infected_parameters->dq_infected_nodes);
		igraph_dqueue_destroy(p_infected_parameters->q_infected_nodes_all);
		free(p_infected_parameters->q_infected_nodes_all);
		//igraph_spmatrix_destroy( p_infected_parameters->weight_mat );
	}else{
		igraph_destroy(p_infected_parameters->p_graph);
		free(p_infected_parameters->p_graph);
		igraph_adjlist_destroy(p_infected_parameters->al);
		free(p_infected_parameters->al);
		igraph_dqueue_destroy(p_infected_parameters->dq_infected_nodes);
		free(p_infected_parameters->dq_infected_nodes);
	}
}

unsigned int getRandomNode(int num_nodes){
	// not quite uniform !! but approximately is good for small number of experiments
	double scaled = (double)rand()/RAND_MAX;
	unsigned int nodeId = floor( scaled * num_nodes);
	return nodeId;
}
